import pandas as pd
import numpy as np
from sklearn.linear_model import LogisticRegression

train = pd.read_csv("train.csv")
test = pd.read_csv("test.csv")

pixel_cols = [c for c in train.columns if c.startswith("pixel")]

X_train = train[pixel_cols].astype(np.float32) / 255.0
y_train = train["label"].values
X_test = test[pixel_cols].astype(np.float32) / 255.0

logreg = LogisticRegression(multi_class="multinomial", solver="lbfgs", max_iter=200)
logreg.fit(X_train, y_train)

test_pred = logreg.predict(X_test)

submission = pd.DataFrame({
    "ImageId": np.arange(1, len(test_pred) + 1),
    "Label": test_pred
})

submission.to_csv("submission.csv", index=False)
print("submission.csv saved")
